// MtoMSIO.cpp : DLL p̏̒`s܂B
//

#include "stdafx.h"
#include "MtoMSioDefs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
//

/////////////////////////////////////////////////////////////////////////////
// CMtoMSIOApp

BEGIN_MESSAGE_MAP(CMtoMSIOApp, CWinApp)
	//{{AFX_MSG_MAP(CMtoMSIOApp)
		// 
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMtoMSIOApp ̍\z

CMtoMSIOApp::CMtoMSIOApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// 

CMtoMSIOApp theApp;


/////////////////////////////////////////////////////////////////////////////
// API

/*===================================================*/
//	MACRO
/*===================================================*/
#define EX_INT_CHECK_HANDLE(p)	if( p == NULL ){	return SIO_MTOM_ERR_PARAM ;	}


/*===================================================*/
//	SIO_CreateMtoMSio
//	---------------------------------------------------
//		Create socket
/*===================================================*/
HANDLE WINAPI SIO_CreateMtoMSio(LPMtoMSioConfig pConfig)
{
	CMemlinkSio* pMemSio = new CMemlinkSio(pConfig) ;
	return (HANDLE)pMemSio ;
}


/*===================================================*/
//	SIO_OpenMtoM
//	---------------------------------------------------
//		Open socket
/*===================================================*/
int WINAPI SIO_OpenMtoM(HANDLE hMSio)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	if( !pMemSio->Open() )
	{
		return SIO_MTOM_ERR_OPEN ;
	}

	return SIO_MTOM_OK ;
}


/*===================================================*/
//	SIO_CloseMtoM
//	---------------------------------------------------
//		Close socket
/*===================================================*/
int WINAPI SIO_CloseMtoM(HANDLE hMSio)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;
	if( pMemSio->IsOpen() )
	{
		pMemSio->Close() ;
	}
	return SIO_MTOM_OK ;
}


/*===================================================*/
//	SIO_FreeMtoMSio
//	---------------------------------------------------
//		Free socket
/*===================================================*/
int WINAPI SIO_FreeMtoMSio(HANDLE hMSio)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	delete pMemSio ;

	return SIO_MTOM_OK ;
}


/*===================================================*/
//	SIO_MtoMGetLastError
//	---------------------------------------------------
//		Get last error number
/*===================================================*/
int WINAPI SIO_MtoMGetLastError(HANDLE hMSio)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->GetLastError() ;
}



/*===================================================*/
//	SIO_MtoMESC_W
//	---------------------------------------------------
//		Write to system area
/*===================================================*/
int WINAPI SIO_MtoMESC_W(HANDLE hMSio,WORD wAddress,INT iDataCount,WORD* pwData)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_W(wAddress,iDataCount,pwData) ;
}


/*===================================================*/
//	SIO_MtoMESC_R
//	---------------------------------------------------
//		Read from system area
/*===================================================*/
int WINAPI SIO_MtoMESC_R(HANDLE hMSio,WORD wAddress,INT iDataCount,WORD* pwoData)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_R(wAddress,iDataCount,pwoData) ;
}


/*===================================================*/
//	SIO_MtoMESC_T
//	---------------------------------------------------
//		Draw text
/*===================================================*/
int WINAPI SIO_MtoMESC_T(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor, INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_T(cDisplayColor,cBackColor,iX1,iY1,cFontSize,szString) ;
}


/*===================================================*/
//	SIO_MtoMESC_L
//	---------------------------------------------------
//		Draw line
/*===================================================*/
int WINAPI SIO_MtoMESC_L(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_L(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iX2,iY2) ;
}


/*===================================================*/
//	SIO_MtoMESC_B
//	---------------------------------------------------
//		Draw rectangle
/*===================================================*/
int WINAPI SIO_MtoMESC_B(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_B(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iX2,iY2) ;
}


/*===================================================*/
//	SIO_MtoMESC_S
//	---------------------------------------------------
//		Draw fill rectangle
/*===================================================*/
int WINAPI SIO_MtoMESC_S(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,INT iX1,INT iY1,INT iX2,INT iY2,GPTILE cTile)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_S(cDisplayColor,cBackColor,iX1,iY1,iX2,iY2,cTile) ;
}


/*===================================================*/
//	SIO_MtoMESC_C
//	---------------------------------------------------
//		Draw circle
/*===================================================*/
int WINAPI SIO_MtoMESC_C(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_C(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius) ;
}


/*===================================================*/
//	SIO_MtoMESC_A
//	---------------------------------------------------
//		Draw arc
/*===================================================*/
int WINAPI SIO_MtoMESC_A(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_A(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle) ;
}


/*===================================================*/
//	SIO_MtoMESC_G
//	---------------------------------------------------
//		Draw sector
/*===================================================*/
int WINAPI SIO_MtoMESC_G(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_G(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle) ;
}


/*===================================================*/
//	SIO_MtoMESC_I
//	---------------------------------------------------
//		Check interrupt
/*===================================================*/
int WINAPI SIO_MtoMESC_I(HANDLE hMSio,BOOL* pbHave,DWORD *pdwCode)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_I(pbHave,pdwCode) ;
}


/*===================================================*/
//	SIO_MtoMESC_t
//	---------------------------------------------------
//		Draw text
/*===================================================*/
int WINAPI SIO_MtoMESC_t(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPFONT cFont,INT iTurn,INT iDirection,INT iHalfcentering,INT iEmphasis,GPCOLOR cSculptrue,INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_t(cDisplayColor,cBackColor,cFont,iTurn,iDirection,iHalfcentering,iEmphasis,cSculptrue,iX1,iY1,cFontSize,szString) ;
}


/*===================================================*/
//	SIO_MtoMESC_l
//	---------------------------------------------------
//		Draw line
/*===================================================*/
int WINAPI SIO_MtoMESC_l(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iArrowPattern,INT iArrowDirection,INT iX1,INT iY1,INT iX2,INT iY2)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_l(cDisplayColor,cBackColor,cLineStyle,iArrowPattern,iArrowDirection,iX1,iY1,iX2,iY2) ;
}


/*===================================================*/
//	SIO_MtoMESC_b
//	---------------------------------------------------
//		Draw rectangle
/*===================================================*/
int WINAPI SIO_MtoMESC_b(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_b(cDisplayColor,cBackColor,cLineStyle,iCornerDirection,iCornerRadius,iX1,iY1,iX2,iY2) ;
}


/*===================================================*/
//	SIO_MtoMESC_s
//	---------------------------------------------------
//		Draw fill rectangle
/*===================================================*/
int WINAPI SIO_MtoMESC_s(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_s(cDisplayColor,cBackColor,cTile,iCornerDirection,iCornerRadius,iX1,iY1,iX2,iY2) ;
}


/*===================================================*/
//	SIO_MtoMESC_c
//	---------------------------------------------------
//		Draw circle
/*===================================================*/
int WINAPI SIO_MtoMESC_c(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iX1,INT iY1,INT iRadius)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_c(cDisplayColor,cBackColor,cTile,iX1,iY1,iRadius) ;
}


/*===================================================*/
//	SIO_MtoMESC_g
//	---------------------------------------------------
//		Draw sector
/*===================================================*/
int WINAPI SIO_MtoMESC_g(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_g(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle) ;
}


/*===================================================*/
//	SIO_MtoMESC_SetContrast
//	---------------------------------------------------
//		Set contrast
/*===================================================*/
int WINAPI SIO_MtoMESC_SetContrast(HANDLE hMSio,DWORD dwContrast,DWORD dwLight) 
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_SetContrast(dwContrast,dwLight) ;
}


/*===================================================*/
//	SIO_MtoMESC_GetContrast
//	---------------------------------------------------
//		Get contrast
/*===================================================*/
int WINAPI SIO_MtoMESC_GetContrast(HANDLE hMSio,DWORD *dwContrast,DWORD *dwLight) 
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_GetContrast(dwContrast,dwLight) ;
}


/*===================================================*/
//	SIO_MtoMESC_Y
//	---------------------------------------------------
//		Draw polygon
/*===================================================*/
int WINAPI SIO_MtoMESC_Y(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iPosCount,INT* piX,INT* piY)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_Y(cDisplayColor,cBackColor,cLineStyle,iPosCount,piX,piY) ;
}


/*===================================================*/
//	SIO_MtoMESC_y
//	---------------------------------------------------
//		Draw polygon
/*===================================================*/
int WINAPI SIO_MtoMESC_y(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iPosCount,INT* piX,INT* piY)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_y(cDisplayColor,cBackColor,cTile,iPosCount,piX,piY) ;
}


/*===================================================*/
//	SIO_MtoMESC_M
//	---------------------------------------------------
//		Show Message
/*===================================================*/
int WINAPI SIO_MtoMESC_M(HANDLE hMSio,GPCOLOR cDisplayColor,GPCOLOR cBackColor,BYTE bFontType,WORD wLanguage,BYTE bPriority,WCHAR* szString)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_M(cDisplayColor,cBackColor,bFontType,wLanguage,bPriority,szString) ;
}


/*===================================================*/
//	SIO_MtoMESC_m
//	---------------------------------------------------
//		Stop Message
/*===================================================*/
int WINAPI SIO_MtoMESC_m(HANDLE hMSio)
{
	CMemlinkSio* pMemSio = (CMemlinkSio*)hMSio ;
	EX_INT_CHECK_HANDLE( pMemSio ) ;

	return pMemSio->ESC_m() ;
}


/*===================================================*/
//	PumpMessage
//	---------------------------------------------------
//		Pump Message
/*===================================================*/
extern void PumpMessage(DWORD dwMillisec = 0)
{
	MSG mes ;
	if( dwMillisec == 0 )
	{
		if( ::PeekMessage( &mes, NULL, NULL, NULL, PM_NOREMOVE)) {
			::GetMessage( &mes, NULL, NULL, NULL ) ;
			::TranslateMessage( &mes );
			::DispatchMessage( &mes ) ;
		}
	}
	else
	{
		DWORD
			dwStart = GetTickCount() ;
		while( difftime( GetTickCount(), dwStart ) < dwMillisec )
		{
			if( ::PeekMessage( &mes, NULL, NULL, NULL, PM_NOREMOVE)) {
				::GetMessage( &mes, NULL, NULL, NULL ) ;
				::TranslateMessage( &mes );
				::DispatchMessage( &mes ) ;
			}
			else
			{
				//	sleep
				Sleep(1) ;
			}
		}
	}

	return ;
}


